//								EJEMPLO 13
//						Autor: Mikel Etxebarria
//			(c) Ingeniera de Microsistemas Programados S.L.
//						www.microcontroladores.com
//								Bilbao 2006
//
//Dcada contadora UP/DOWN de un dgito
//
//Sobre el display 7 segmentos conectado a la puerta B se visualizar el nmero de pulsos 
//aplicados por la entrada RA0. RA1 determina si la cuenta es ascendente (a "1")
//o descendente

#include <16f876A.h>

//Ajusta los valores de la palabra de configuracin durante el ensamblaje:
//Proteccin de cdigo y datos=OFF, LVP=OFF, WDT=OFF y OSC=XT

#fuses NOPROTECT,NOCPD,NOLVP,NOWDT,XT

// Con estas directivas las funciones "input" y "output_bit" no reprograman
// el pin de la puerta cada vez que son utilizadas. Si no se indica el
// modo fast_io se asume por defecto standard_io el cual reprograma el pin
// siempre antes de ser utilizadas estas funciones.

#use fast_io (A)
#use fast_io (B)
#use delay(clock=4000000)

int	contador=0;

main()
{  
	unsigned int const display[16]={0x3F,0x06,0x5B,0x4F,// Al ser una tabla constante
                               0x66,0x6D,0x7D,0x07,		// se crea dentro de la memoria
                               0x7F,0x6F,0x77,0x7C,		// de programa.
                               0x39,0x5E,0x79,0x71};

	SETUP_ADC_PORTS(NO_ANALOGS);	//Puerta A Digital
	set_tris_a(0x3F);				//RA0-RA5 entradas
	set_tris_b(0x00);				//RB0-RB7 salidas	   
	output_b (0x00);				//Borra las salidas

	while(1)
	{
	output_b (display[contador&0x0f]); //Visualiza el contador
	while (input(PIN_A0));	//Transcin 1-0 del pulso a contar
	delay_ms(10);			//Temporizar 10mS para eliminar rebotes
	while (!input(PIN_A0));	//Transicin 0-1 del pulso a contar
	delay_ms(10);			//Temporizar 10ms para eliminar rebotes
	
	if (input(PIN_A1))
		++contador ;	//Incremento del contador
	else
		--contador ;	//Decremento del contador
	}
}	



